module net.BurtonRadons.digstrip.platform.scintilla;

private import net.BurtonRadons.digstrip.platform.control;
private import net.BurtonRadons.digstrip.platform.windows; 


template ScintillaListenerType(T1)
{
    alias void delegate(T1 t1) Func;

    struct Listener
    {
        protected Func[Func] _listeners;       // set of delegates

        void add(Func func)
        {
            _listeners[func] = func;
        }
        
        void erase(Func func)
        {
            if (func in _listeners)
                delete _listeners[func];
        }
        
        void fire(T1 t1)
        {
            Func[] f = _listeners.keys;
            for (int i = 0; i < f.length; i++)
                f[i](t1);
        }
    }
}

struct ScintillaEventArgs
{
    
    int position;       // SCN_STYLENEEDED, SCN_MODIFIED, SCN_DWELLSTART, SCN_DWELLEND
    int ch;             // SCN_CHARADDED, SCN_KEY
    int modifiers;      // SCN_KEY
    int modificationType;       // SCN_MODIFIED
    char *text;         // SCN_MODIFIED
    int length;         // SCN_MODIFIED
    int linesAdded;     // SCN_MODIFIED
    int message;        // SCN_MACRORECORD
    void* wParam;       // SCN_MACRORECORD
    void* lParam;       // SCN_MACRORECORD
    int line;           // SCN_MODIFIED
    int foldLevelNow;   // SCN_MODIFIED
    int foldLevelPrev;  // SCN_MODIFIED
    int margin;         // SCN_MARGINCLICK
    int listType;       // SCN_USERLISTSELECTION
    int x;              // SCN_DWELLSTART, SCN_DWELLEND
    int y;              // SCN_DWELLSTART, SCN_DWELLEND
}

alias instance ScintillaListenerType(ScintillaEventArgs).Listener ScintillaListener;


class ScintillaText
{
    
    public
    {
        static const int SCI_GETDIRECTFUNCTION = 2184;
        static const int SCI_GETDIRECTPOINTER = 2185;

        this()
        {
		}
    }
}


struct ScintillaCharacterRange
{
    long cpMin;
    long cpMax;
}

struct ScintillaTextRange
{
    ScintillaCharacterRange chrg;
    char *lpstrText;
}

struct ScintillaTextToFind
{
    ScintillaCharacterRange chrg;
    char *lpstrText;
    ScintillaCharacterRange chrgText;
}

